/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   EZLink Resource Framework API Header File
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __RESOURCE_EZLINK_H
#define __RESOURCE_EZLINK_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <resource.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)

typedef void (*EasyLinkNotifyFuncPtr)(E_ModuleResource, NativePtrSizedInt_U in_uAppData, uint1 in_u1BytesSent);

typedef enum
{
    USE_EZLINK_CONDITION = 0x01,
    USE_EZLINK_DYNAMIC_ON_CREATE = 0x02,

/* IF THIS TYPE EXCEEDS 0x80 THEN ALTER THE TYPE OF THE uValidAttributesMask MEMBER(S) ACCORDINGLY */

} E_EZLinkAttributesMask;

typedef struct
{
    uint1 uValidAttributesMask;
    E_ResourceCond eResourceCondition;
} S_EZLinkResourceAttributes;

typedef S_EZLinkResourceAttributes const* S_EZLinkResourceAttributesPtr;

typedef struct
{
    uint1 uValidAttributesMask;
    S_EZLinkResourceAttributes DynamicObj;
} S_EZLinkCreateResourceAttributes;

typedef S_EZLinkCreateResourceAttributes const* S_EZLinkCreateResourceAttributesPtr;

/* Transmit data structure                */
/* All members must be defined when using */
typedef struct
{
    void const* pData;
    uint1 u1NumBytesToTX;
    NativePtrSizedInt_U uAppDataDeliveredOnNotify;
    EasyLinkNotifyFuncPtr pfNotify;
} S_EZLinkTransmitData;

#pragma pack()
/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
/* Optimised calls that can be applied to certain attribute get/sets                                       */
NativeError_S GetEZLinkResourceStatus(E_ModuleResource,uint1* ou1_pu1Status);
NativeError_S TransmitEZLinkData(E_ModuleResource, S_EZLinkTransmitData const*);

/* DO NOT use these functions directly. They are implicitly called through the use of the CreateResource() */
/*   and SetResourceAttributes() macro functions                                                           */
NativeError_S CreateResourceBEHAVIOUR_EZLINK(E_ModuleResource, S_EZLinkCreateResourceAttributes const*);
NativeError_S DestroyResourceBEHAVIOUR_EZLINK(E_ModuleResource);
NativeError_S SetResourceAttributesBEHAVIOUR_EZLINK(E_ModuleResource, S_EZLinkResourceAttributes const*);

#endif /* __RESOURCE_EZLINK_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
